# Theming

## Background picture requirements

A reference to why it was very difficult to actually find good background pictures – there are quite some requirements when it comes to picking:

- It needs to be an exceptionally good photo of course – since when chosen, people will see it every day.
- We need to have a good balance of different motives, e.g. not too many landscape pics.
- Same for a good balance of different colors.
- The photo needs to work as a background. Photos with objects focused in the middle don’t really work as they will be overlapped by the widgets and content anyway.
- Especially the top part cannot have too much differing contrast, as then it’s not possible to see the navigation icons.
- Especially the top part should be either dark-ish or light-ish, but not a shade exactly inbetween because then contrast can neither be achieved with light nor dark icons.
- We serve the pictures at 4k resolution and most of the selected images are also available in 6k or higher so it is future-proof.
- For the search of course we had to limit to CC0, CC By and CC By-Sa. Only CC0 would have been practically impossible cause there’s just not so many good ones which fit.
- Good pages to find photos are [StockSnap](https://stocksnap.io), [Wikimedia Commons](https://commons.wikimedia.org), [Openverse](https://wordpress.org/openverse/) and [Flickr (with license "commercial use & mods allowed")](https://flickr.com/search/?license=4%2C5%2C9%2C10&text=Nextcloud), sorting by interesting or downloads. Most others like Unsplash, Pexels, Pixabay, etc. meanwhile have a non-standard license.


## Background picture technicals
- All backgrounds are sized to maximum 3840px width (4K resolution).
- To ensure quick loading times, the image needs to be compressed, ideally to around 1 MB or less. E.g. via 90–95% quality in GIMP export. We could also explore using newer formats.
- Previews are sized to 352px width (min height 192px), which is double of the current picker grid size so it looks nice on high-res displays. Quality is also set to around 90% at export.


## Background picture credits

In `img/background/`:

- Default background: [Clouds (Kamil Porembiński, CC BY-SA)](https://www.flickr.com/photos/paszczak000/8715851521/) – original 4k, color modified and sky color changed to Nextcloud blue.
- Default dark mode background: [Pedra azul milky way (Eduardo Neves, CC BY-SA)](https://commons.wikimedia.org/wiki/File:Pedra_Azul_Milky_Way.jpg) – original 5k.
- [Soft floral (Hannah MacLean, CC0)](https://stocksnap.io/photo/soft-floral-XOYWCCW5PA) – original 5.5k.
- [Morning fog (Ted Moravec, Public Domain)](https://flickr.com/photos/tmoravec/52392410261) – original 3k.
- [Underwater ocean (Stefanus Martanto Setyo Husodo, CC0)](https://stocksnap.io/photo/underwater-ocean-TJA9LBH4WS) – original 5k.
- [Rhythm and blues (Zoltán Vörös, CC BY)](https://flickr.com/photos/v923z/51634409289/) – original 2k (it’s fine since the motive is blurry anyway).
- [Butterfly wing scale (Anatoly Mikhaltsov, CC BY-SA)](https://commons.wikimedia.org/wiki/File:%D0%A7%D0%B5%D1%88%D1%83%D0%B9%D0%BA%D0%B8_%D0%BA%D1%80%D1%8B%D0%BB%D0%B0_%D0%B1%D0%B0%D0%B1%D0%BE%D1%87%D0%BA%D0%B8.jpg) – original 5k, cropped to use top right and retouched away a bright spot, now 4k.
- [Cetonia aurata take off composition (Bernie, Public Domain)](https://commons.wikimedia.org/wiki/File:Cetonia_aurata_take_off_composition_05172009.jpg) – original 8k.
- [Ribbed red metal (Dejan Krsmanovic, CC BY)](https://www.flickr.com/photos/dejankrsmanovic/42971456774/) – original 5k.
- [Barents bloom (European Space Agency, CC BY-SA)](https://www.esa.int/ESA_Multimedia/Images/2016/08/Barents_bloom) – original 2k (it’s fine since the motive is blurry anyway), rotated 90° right.
- [Flippity floppity (Hannes Fritz, CC BY-SA)](http://hannes.photos/flippity-floppity) – original 4k, cropped to top left (2k) so the sharp parts are not part of the photo, looks better.
- [Roulette (Hannes Fritz, CC BY-SA)](http://hannes.photos/roulette) – original 4k.
- [Sea spray (Hannes Fritz, CC BY-SA)](http://hannes.photos/sea-spray) – original 6k.
- [New zealand fern (Bernard Spragg, CC0)](https://commons.wikimedia.org/wiki/File:NZ_Fern.(Blechnum_chambersii)_(11263534936).jpg) – original 2.5k.
- [Pink tapioca bubbles (Rawpixel, CC BY)](https://www.flickr.com/photos/byrawpixel/27665140298/in/photostream/) – original 6k.
- [Waxing crescent moon (NASA, Public Domain)](https://www.nasa.gov/image-feature/a-waxing-crescent-moon)
- [Cityscape (Tommy Chau, CC BY)](https://www.flickr.com/photos/90975693@N05/16910999368) – original 6k.
- [Lion rock hill (Tommy Chau, CC BY)](https://www.flickr.com/photos/90975693@N05/17136440246) – original 6k.
- [Yellow bricks (Lali Masriera, CC BY)](https://www.flickr.com/photos/visualpanic/3982464447) – original 4k, color modified for visibility of icons, and slightly cropped on the left so motive is centered.